FUNCTION spzap,sparray,l0,l1,order=ORDER

; 20 Jul 04 copied from spcut.pro
;
; spzap removes data in a spectral data array between wavelengths l0 and l1
; INPUT
;   sparray - input spectral data array
;   l0      - minimum wavelength of range to zap
;   l1      - maximum wavelength of range to zap
;   order   - order to zap
;             if set, expects order info in col 3
;             if out of range, then nothing trimmed

if (n_elements(order) eq 0) then ordflag=0 else ordflag=1
zapflag=1
full_len=n_elements(reform(sparray[0,*]))

; isolate relevant order as ordarray

if (ordflag eq 1) then begin
  ord_idx=where(sparray[3,*] eq order)
  if (max(ord_idx) gt -1) then begin
    ordarray=sparray[*,ord_idx] 
  endif else begin
     print,'Warning in spzap.  No data in order ',$
       order,'.  Returning input array.'
     zapflag=0
  endelse
endif else ordarray=sparray ; no order set, load full input array

; zap data in ordarray, put into savearray

if (zapflag eq 1) then begin
  lam=reform(ordarray[0,*])
  out_idx=where( (lam lt l0) or (lam gt l1) )
  if (max(out_idx gt -1)) then savearray=ordarray[*,out_idx] $
  else begin
    print,'Warning in spzap.  No data in range ',$
      l0,' - ',l1,'.  Returning input array.'
  savearray=ordarray
  endelse 
endif

; build output array

if (zapflag eq 0) then outarray=sparray ; load full input array
if (zapflag eq 1) then begin

; load orders before active order, active order (as cut), then orders after

  if (ordflag eq 0) then outarray=savearray else begin
    minact=min(ord_idx) & maxact=max(ord_idx)
    if (minact gt 0) then begin
      outarray=sparray[*,0:minact-1]
      outarray=[[outarray],[savearray]]
    endif else outarray=savearray
    if (maxact lt full_len-1) then $
      outarray=[[outarray],[sparray[*,maxact+1:full_len-1]]]
  endelse

endif

return,outarray

END
