FUNCTION spspot,sp,lam,ORDER=order

;  4 Nov 04 ensure that returned value is not an array of one element
; 14 Oct 04 created
;
; spspot determines the flux in a spectrum at a given wavelength
; if the wavelength appears in the spectrum exactly, the flux is returned
; else the interpolated flux between the two neighbors is returned
; if lam out of range of spectrum, min or max is returned with a warning
;
; INPUT
;   sp  - spectral data array
;   lam - wavelength in units matching those in col 0 of spectral data array
;   order - optional keyword to limit analysis to one order
; OUTPUT - returns flux at lam, exact or interpolated

lcol=0 & fcol=1 & ocol=3
spo=sp

if (n_elements(order) eq 1) then begin
  idx=where(sp[ocol,*] eq order)
  if (max(idx) gt -1) then spo=sp[*,idx] else $
    print,'Warning in spspot.  No data in order, using full array'
endif

idx=where(sp[lcol,*] eq lam)
if (max(idx) gt -1) then begin ; matched wavelength exactly
  return,mean(sp[fcol,idx])
endif else begin ; either out of range or must interpolate
  lessidx=where(spo[lcol,*] lt lam)
  moreidx=where(spo[lcol,*] gt lam)
  if (max(lessidx) gt -1) then begin ; have data to blue
    lessflag=1
    spless=spo[*,lessidx]
    maxless=max(spless[lcol,*],spot0)
  endif else lessflag=0
  if (max(moreidx) gt -1) then begin ; have data to red
    moreflag=1
    spmore=spo[*,moreidx]
    minmore=min(spmore[lcol,*],spot1)
  endif else moreflag=0
  if (lessflag eq 1 and moreflag eq 1) then begin ; interpolate
    l0=spless[lcol,spot0] & l1=spmore[lcol,spot1]
    f0=spless[fcol,spot0] & f1=spmore[fcol,spot1]
    return,f0 + (f1-f0)*(lam-l0)/(l1-l0)
  endif else begin
    print,'Warning in spspot.  Data out of range, returning closest value.'
    if (lessflag eq 1) then begin ; no data to red of lam, take max
      maxdata=max(spo,maxspot)
      return,maxspot
    endif
    if (moreflag eq 1) then begin ; no data to blue of lam, take min
      mindata=min(spo,minspot)
      return,minspot
    endif
  endelse  
endelse

END
