FUNCTION spmin,sparray,l0,l1,lmin

;  3 Jan 06 added lmin optional parameter
; 16 Mar 05 created by modifying spmax.pro
;
; spmax returns the maximum flux between l0 and l1
;
; INPUT
;   sparray - input spectral array
;   l0,l1   - range to check for max, l1 must be greater than l0
;   lmin    - if given, used to return wavelength at minimum
; OUTPUT - returns max flux between l0 and l1

lcol=0 & fcol=1

lambda=sparray[lcol,*]
flux=sparray[fcol,*]

if (n_elements(l0) eq 0) then l0=min(lambda)
if (n_elements(l1) eq 0) then l1=max(lambda)
index=where(lambda ge l0 and lambda le l1)

if (max(index) gt -1) then begin
  minflux=min(flux[index],minspot) 
  lmin=lambda[lcol,index[minspot]]
  RETURN,minflux
endif else begin
  print,'Error in spmin.  No data in range ',l0,' - ',l1
  RETURN,0
endelse

END
