FUNCTION speqf,sp,la0,la1,lb0,lb1,lc,feqf,sfeq,weq,DIAG=diag

; 17 Jun 05 no longer crashes if no error column set
; 12 Dec 04 add diagnostic keyword
;  8 Dec 04 sort the spectrum to be safe 
; 14 Nov 04 created by modifying fitlinx.pro
;
; modifications in fitlinx.pro
;  7 May 03 to give interpolated lc when wavelength grid is coarse
;           and to give avg of lc for sums from each end of interval
; 27 Apr 03 to calculate equivalent width
;  6 Mar 03 to include error in continuum
; 13 May 02 to determine error
;           also to avoid crash for large arrays, stay in bounds
; 22 Oct 01 to compute correct lc for feqf < 0
;  8 Oct 01 by modifying fitline to return l_c and f_eq
; as fitline.pro
; 22 Dec 00 to print out central wavelength
; 30 Oct 97 to print out feature flux
; 23 Oct 97 created
;
; fits a line over two wavelength ranges
; the idea is that this will serve as a continuum for the region between
;
; INPUT
;   sp       input spectral array columns are l,f,e,...
;   l,f,e    wavelength, flux, error vectors, flux in F_nu units expected
;   la0-la1  first wavelength range
;   lb0-lb1  second wavelength range
; OUTPUT - returns vector fluxes with line removed from la0 to lb1, 0 outside
;   lc       central wavelength
;   feqf     equivalent integrated flux of feature (in W m^-2)
;   sfeq     uncertainty in feqf
;   weq      equivalent width (um)
; if lambda vector in um and f,e vectors in Jy, then output in W m^-2

if (keyword_set(diag)) then diagflag=1 else diagflag=0

; sort the spectrum

idx=sort(sp[0,*])
spnew=sp[*,idx]

; set stops from input wavelength ranges

lcol=0 & fcol=1 & ecol=2
l=reform(spnew[lcol,*])
f=reform(spnew[fcol,*])
if (n_elements(spnew[*,0]) gt 2) then errflag=1 else errflag=0
if (errflag eq 1) then e=reform(spnew[ecol,*])

q=size(l)
jstop=q[1]-1
j=long(0) &     while (l[j] lt la0 and j lt jstop-1) do j=j+1 & ja0=j
j=long(0) &     while (l[j] lt lb0 and j lt jstop-1) do j=j+1 & jb0=j
j=long(jstop) & while (l[j] gt la1 and j gt 1)       do j=j-1 & ja1=j
j=long(jstop) & while (l[j] gt lb1 and j gt 1)       do j=j-1 & jb1=j

; find average flux and wavelength to either side of feature

ffa=total(f[ja0:ja1])/(ja1-ja0+1)
lla=total(l[ja0:ja1])/(ja1-ja0+1)
ffb=total(f[jb0:jb1])/(jb1-jb0+1)
llb=total(l[jb0:jb1])/(jb1-jb0+1)

if (diagflag eq 1) then print,lla,llb,ffa,ffb
if (diagflag eq 1) then print,l[jb0:jb1]
if (diagflag eq 1) then print,f[jb0:jb1]

; calculate continuum flux under the feature (and to either side)

ff=f
for j=ja0,jb1 do ff[j] = ffa + (l[j]-lla) * (ffb-ffa)/(llb-lla)

; find root-mean-square error in continuum fit on each side of feature

fsiga=0
for j=ja0,ja1 do fsiga = fsiga + (ff[j]-f[j])^2.0
fsigb=0
for j=jb0,jb1 do fsigb = fsigb + (ff[j]-f[j])^2.0
if (ja1 ne ja0) then fsiga = fsiga / ((ja1-ja0+1)*(ja1-ja0))
if (jb1 ne jb0) then fsigb = fsigb / ((jb1-jb0+1)*(ja1-ja0))
fsig  = sqrt(fsiga+fsigb)

; sum fluxes and errors from continuum and total

feqt=0.0 & feqc=0.0 & weq=0.0 & seq=0.0
for j=ja1+1,jb0-1 do begin
  k = (l[j]-l[j-1]) * 3e-12 / (l[j]*l[j])
  feqt = feqt +  f[j] * k
  feqc = feqc + ff[j] * k
  weq  = weq  + (ff[j]-f[j])*(l[j]-l[j-1])/ff[j]
  if (errflag eq 1) then seq  = seq  +  e[j]*e[j] * k*k
endfor

; feature is total - continuum

feqf=feqt-feqc

; find central wavelength of feature

if (feqf lt 0.0) then signf=-1 else signf=1
feqtest=0.5*signf*feqf

; sum in positive wavelength direction

feqpart=0.0 & flag=0 & lcp=0.0
for j=ja1+1,jb0-1 do begin
  l0=l[j-1]
  l1=l[j]
  k = (l1-l0) * 3e-12 / (l1*l1)
  feqlast = feqpart
  feqpart = feqpart +  signf*(f[j]-ff[j]) * k
  if (feqpart gt feqtest and flag eq 0) then begin
    flag=1
    lcp = l0 + (feqtest-feqlast) * (l1-l0) / (feqpart-feqlast)
    lcp = lcp + 0.5*(l1-l0) ; correction fr edge of pixel to center
  endif
endfor

; sum in negative wavelength direction

feqpart=0.0 & flag=0 & lcn=0.0
for j=jb0-1,ja1+1,-1 do begin
  l0=l[j+1]
  l1=l[j]
  k = (l0-l1) * 3e-12 / (l1*l1)
  feqlast = feqpart
  feqpart = feqpart +  signf*(f[j]-ff[j]) * k
  if (feqpart gt feqtest and flag eq 0) then begin
    flag=1
    lcn = l0 + (feqtest-feqlast) * (l1-l0) / (feqpart-feqlast)
    lcn = lcn + 0.5*(l1-l0) ; correction fr edge of pixel to center
  endif
endfor

; average central wavelength for two summing directions

lc = (lcp+lcn)/2.0

; find error in extraction (seq) and continuum fit (ceq)
; add these in quadrature and save as sfeq
; need to convert fsig to F_Lam units

if (errflag eq 1) then begin
  fsig = fsig * 3e-12 / (lc*lc)
  ceq = (fsig*(l[jb0]-l[ja1]))^2.0
  sfeq = sqrt(seq+ceq)
endif else sfeq=0

; be sure to unsort the spectrum before returning the continuum

retsp=sp
retsp[1,idx]=ff

return,retsp
END
