FUNCTION spcut,sparray,l0,l1,ORDER=order,ALL=all

; 28 Jan 06 corrected error resulting in change to l0 and l1 
; 21 Aug 05 added ALL keyword to cut entire order, must set ORDER keyword, too
; 27 Mar 04 added option to cut only one order at a time
;  1 Feb 04 return error message and orig. data if no data in range
; 26 Jan 04 created
;
; spcut trims a spectral data array to the wavelength range l0-l1
; it is best to apply this to only one spectral segment at a time
; INPUT
;   sparray - input spectral data array
;   l0      - minimum wavelength to save
;   l1      - maximum wavelength to save
;   order   - optional parameter, order to trim
;             if set, expects order info in col 3
;             if out of range, then nothing trimmed
;   all     - optional keyword, works only if order set
;             will trim entire order

lcol=0 & ocol=3
if (n_elements(order) eq 0) then ordflag=0 else ordflag=1
if (ordflag eq 1 and keyword_set(all) eq 1) then allflag=1 else allflag=0
full_len=n_elements(reform(sparray[lcol,*]))
cutflag=1

; load lambda stops from input l0 and l1 (so that l0 and l1 don't change)

if (allflag eq 0) then begin
  la=l0 & lb=l1
endif else begin
  la=0 & lb=0
endelse

; isolate relevant order as ordarray

if (ordflag eq 1) then begin
  ord_idx=where(sparray[ocol,*] eq order)
  if (max(ord_idx) gt -1) then begin
    ordarray=sparray[*,ord_idx] 
    if (allflag eq 1) then begin ; reset la and lb to max of order and max+1
      la=max(ordarray[lcol,*])
      lb=la+1
    endif
  endif else begin
     print,'Warning in spcut.  No data in order ',$
       order,'.  Returning input array.'
     cutflag=0
  endelse
endif else ordarray=sparray ; no order set, load full input array

; perform cut on ordarray, put into savearray

if (cutflag eq 1) then begin
  lam=reform(ordarray[lcol,*])
  out_idx=where( (lam ge la) and (lam le lb) )
  if (max(out_idx gt -1)) then savearray=ordarray[*,out_idx] $
  else begin
    if (allflag eq 0) then print,'Warning in spcut.  No data in range ',$
      l0,' - ',l1,'.  Returning input array.'
    savearray=ordarray
  endelse 
endif

; build output array

if (cutflag eq 0) then begin
  outarray=sparray                            ; load full input array
endif else begin

; load orders before active order, active order (as cut), then orders after

  if (ordflag eq 0) then outarray=savearray else begin
    minact=min(ord_idx) & maxact=max(ord_idx)
    if (minact gt 0) then begin
      outarray=sparray[*,0:minact-1]
      if (allflag eq 0) then begin
        outarray=[[outarray],[savearray]]
      endif 
    endif else outarray=savearray
    if (maxact lt full_len-1) then $
      outarray=[[outarray],[sparray[*,maxact+1:full_len-1]]]
  endelse

endelse

return,outarray

END
