FUNCTION spcut,sparray,l0,l1

;  1 Feb 04 return error message and orig. data if no data in range
; 26 Jan 04 created
;
; spcut trims a spectral data array to the wavelength range l0-l1
; it is best to apply this to only one spectral segment at a time

lam=reform(sparray[0,*])
out_idx=where( (lam ge l0) and (lam le l1) )

if (max(out_idx gt -1)) then outarray=sparray[*,out_idx] $
else begin
  print,'Error in spcut.  No data in range ',l0,' - ',l1,' returning input array'
  outarray=sparray
endelse

return,outarray

END
