PRO imfclean,im_file,out_file,module,BMASK=bmask,CMASK=cmask,OUTMASK=outmask,ROGUE=rogue,VERSION=version,_extra=e

;  5 Dec 05 updated version number to 2.1 to reflect changes in names of
;           other routines to avoid collisions with the SSC's irsclean
;  5 Aug 05 changed hard-coded path to omask files, added version keyword
;  2 Aug 05 renamed array variables to avoid conflicts with file names
; 31 Mar 05 added cmask option
;  5 Jan 05 tidying up comments
; 20 Dec 04 added an OUTMASK parameter to save updated bmask
; 17 Dec 04 now reads the SSC order mask file and passes it to imclean.pro
; 27 Aug 04 some functionality added
; 29 Jul 04 created
;
; a wrapper which calls imclean after loading FITS files and then
;   saves the result to disk as a FITS file
;
; INPUT
;   im_file   file name of IRS image in FITS format
;   out_file  file name for output image in FITS format
;   module    0 = SL, 1 = SH, 2 = LL, 3 = LH
;             this parameter determines which order mask will be used
;   bmask     optional parameter, if set, reads in bmask file and
;             and passes the bmask to imclean.pro
;             the user can set maskval here if they wish
;   cmask     optional parameter, if set, reads in a campaign mask file
;             this is single-bit and can be or'ed with the bmask
;   outmask   optional parameter to save modified updated bmask to disk
;   rogue     optional parameter, if set, reads in comparison image for
;               generation of a rogue mask - NOT RECOMMENDED
;   version   optional keyword to output version number of program

; verify version

if (keyword_set(version)) then print,'imfclean version 2.1, 5 Dec, 2005'

; load input image

im=readfits(im_file,header,/silent)

; load order mask

path='/usr/local/rsi/idl_library/IRS_pro/imclean/' ; must set path manually
case module of
  0 : om=readfits(path+'b0_omask.fits')
  1 : om=readfits(path+'b1_omask.fits')
  2 : om=readfits(path+'b2_omask.fits')
  3 : om=readfits(path+'b3_omask.fits')
endcase

; prepare input parameters

if (keyword_set(bmask) ne 0) then bm=readfits(bmask,bhdr,/silent) else bm=0
if (keyword_set(cmask) ne 0) then cm=readfits(cmask,/silent) else cm=0
if (keyword_set(rogue) ne 0) then rog=readfits(rogue,/silent) else rog=0

; clean image

new = imclean(im,om,maskim=bm,maskout=bm_new,cmask=cm,rogue=rog,_extra=e)

; write results

writefits,out_file,new,header

; if outmask and maskim set, write outmask (returned from imclean as bm_new)

if (keyword_set(outmask) ne 0 and keyword_set(bmask) ne 0) then $
  writefits,outmask,bm_new,bhdr

END
